#define    USB         ((XBYTE *)0xFF00)
        #define    DCON        0xC0	
        	#define    PTRWKE      0x02      // Pass Through Remote Wakeup Enable
                #define    EP3DIR      0x08      // 1 for IN , 0 for OUT
                #define    TSTMD       0x80      // Test mode enable
        #define    PLLCON      0xC1              //
        #define    UPCON       0xC9
        	#define    USUS        0x01      // Function Suspend 
		#define    URSM        0x02      // Function Resume 
		#define    URST        0x04      // USB Reset
		#define    URWU        0x20      // Function Remove Wake-up Enable
        	#define    CONEN       0x80      // USB Connect Enable.
        #define    ACKCTL      0xCC
	        #define    EN_DLL      0x01
		#define    UCK_SEL     0x02
		#define    XI2ACK      0x08
		#define    ACKEN       0x10
		#define    USBCKD      0x20
		#define    EPLLEN      0x80
        #define    UADDR       0xD8
        #define    IEN         0xD9
		#define    EF          0x02	 // Enable Function	
		#define    EFSR        0x04      // Enable Function Suspend/Resume
        #define    UIE         0xDA
	        #define    UTXIE0      0x01
	        #define    URXIE0      0x02
	        #define    UTXIE1      0x04
	        #define    UTXIE2      0x10
	        #define    ASOFIE      0x40
	        #define    SOFIE       0x80
        #define    UIFLG       0xDB
		#define    UTXD0       0x01
		#define    URXD0       0x02
		#define    UTXD1       0x04
		#define    UTXD2       0x10
		#define    ASOFIF      0x40
		#define    SOFIF       0x80
	#define    UIE1        0xDC
	        #define    UTXIE3      0x01
	        #define    URXIE3      0x02
	        #define    URXIE4      0x08
	        #define    UTXIE5      0x10
	        #define    FSIE        0x80
        #define    UIFLG1      0xDD
		#define    UTXD3       0x01
	        #define    URXD3       0x02
	        #define    URXD4       0x08
	        #define    UTXD5       0x10
	        #define    FSIF        0x80
	#define    EPCON       0xE1
		#define    TXEPEN      0x01      
		#define    TXISO       0x02
		#define    RXEPEN      0x04  
		#define    RXISO       0x08    
		#define    TXDBM       0x01      
		#define    RXDBM       0x02
		#define    TXSTL       0x40      
		#define    RXSTL       0x80 
        #define    RXSTAT      0xE2
		#define    ISOSOVW     0x04
		#define    RXSOVW      0x08
		#define    EDOVW       0x10
		#define    STOVW       0x20
		#define    RXSETUP     0x40
		#define    RXSEQ       0x80
	#define    RXDAT       0xE3
	#define    RXCON       0xE4
		#define    RXFFRC      0x10      // RX FIFO Read Complete
		#define    RXCLR       0x80	 // Receive FIFO Clear
	#define    RXCNT       0xE6
	#define    EPINDEX     0xF1
		#define    EP0         0x00	 // EPO 
		#define    EP1         0x01      // EP1
		#define    EP2         0x02      // EP2
		#define    EP3         0x03      // EP3
		#define    EP4         0x04      // EP4 
		#define    EP5         0x05      // EP5
	#define    TXSTAT      0xF2
		#define    TXSOVW      0x08
		#define    TXSEQ       0x80
	#define    TXDAT       0xF3
	#define    TXCON       0xF4
                #define    TXFFRC      0x10      // TX FIFO Read Complete
		#define    TXCLR       0x80	 // Transmit FIFO Clear	
	#define    TXCNT       0xF6

	#define    SFMCTL      0xCD              //
              	#define    SFINX0      0x01
                #define    SFINX1      0x02
                #define    SFINX2      0x04
                #define    SFINX3      0x08
                #define    FT_G0       0x10      //
                #define    FT_G1       0x20      // 
                #define    DECEN       0x40
                #define    INCEN       0x80
	#define    SIFCFG      0xD0
	        #define    BCLKP       0x01
	        #define    FSYCP       0x02
		#define    DFSYC       0x04
		#define    SD16EN      0x08
		#define    PCMI_EN     0x40
	#define    SDFCFG      0xD1
	        #define    ASRS0       0x01
		#define    ASRS1       0x02
		#define    ASRS2       0x04
		#define    PCM8EN      0x10
	        #define    AOMON       0x40
	        #define    AISTERO     0x80
	#define    SIOCTL      0xC2              //
                #define    MCKOE0      0x01
                #define    MCKOE1      0x02
                #define    MCKFD       0x04
                #define    SIFOE       0x08      // Real singal will be OUTPUT
                #define    DMI         0x40
                #define    DPI         0x80	        
	#define    AFCTL       0xD2
	        #define    AOFEN       0x01
		#define    ADO_ME      0x02
		#define    MIXEN       0x04
		#define    LPBEN       0x08
		#define    AIFEN       0x10
		#define    ADI_ME      0x20
		#define    SIFEN       0x80
	#define    GS_LCO      0xD4
        #define    GS_RCO      0xD5
        #define    GS_ADI      0xD6
        #define    GS_MIX      0xD7
	#define    PFTL        0xCE
        #define    PFTH        0xCF
        	#define    BFA         0x80
        	
/*
#define    USB         ((XBYTE *)0x00)
        #define    DCON        0xC0	
        	#define    CONPUEN     0x01      // Device USP Connection Pull-Up Enable
                #define    PTRWUEN     0x02      // Pass Through Remote Wakeup Enable
                #define    TEST_MODE   0x80      // Test mode enable
	#define    FADDR       0xD8
	#define    FPCON       0xC9
		#define    FSUS        0x01      // Function Suspend 
		#define    FRSM        0x02      // Function Resume 
		#define    FWKP        0x04      // Function Wake-up
		#define    URST        0x08      // USB Reset
		#define    URDIS       0x10      // USB Reset Disable
		#define    FRWU        0x20      // Function Remove Wake-up Enable
		#define    FRWUPE      0x40      // Function Remove Wake-up Enable
		#define    FPD         0x80      // Function Powerdown Mode
//	#define    RWUEN       0xCA              // Remote Wakeup Enable for P1
	#define    FIE         0xDA
	        #define    FTXIE0      0x01
	        #define    FRXIE0      0x02
	        #define    FTXIE1      0x04
	        #define    FTXIE2      0x08
	        #define    FTXIE3      0x10      // EP3 could be configure to IN or OUT
	        #define    FRXIE3      0x10
	        #define    SOFIE       0x40
	        #define    ASOFIE      0x80
	#define    FIFLG       0xDB
		#define    FTXD0       0x01
		#define    FRXD0       0x02
		#define    FTXD1       0x04
		#define    FTXD2       0x08
		#define    FRXD3       0x10
		#define    SOFIF       0x40
		#define    ASOFIF      0x80
	#define    SIFCFG      0xD0
	        #define    BCLKP       0x01
	        #define    FSYCP       0x02
		#define    DFSYC       0x04
		#define    SD16EN      0x08
		#define    SI_AUX      0x20
		#define    PCMI_EN     0x40
		#define    UP2FSE      0x80
	#define    SDFCFG      0xD1
	        #define    FCKS0       0x01
		#define    FCKS1       0x02
		#define    FCKS2       0x04
	        #define    XI2FCK      0x08
		#define    PCM8EN      0x10
	        #define    AOMON       0x40
	#define    AFCTL       0xD2
	        #define    AOFEN       0x01
		#define    ADO_ZE      0x02
		#define    MIXEN       0x04
		#define    DPBEN       0x08
		#define    AIFEN       0x10
		#define    ADI_ZE      0x20
		#define    AIRCE       0x40
		#define    SIFEN       0x80
        #define    LCO_GS      0xD4
        #define    RCO_GS      0xD5
        #define    ADI_GS      0xD6
        #define    MIX_GS      0xD7
        #define    IEN1        0xD9
		#define    EF          0x02	 // Enable Function	
		#define    EFSR        0x08      // Enable Function Suspend/Resume
	#define    EPINDEX     0xF1
		#define    EP0         0x00	 // EPO 
		#define    EP1         0x01      // EP1
		#define    EP2         0x02      // EP2
		#define    EP3         0x03      // EP3
		#define    EP4         0x04      // EP4
	#define    EPCON       0xE1
		#define    TXEPEN      0x01      
		#define    RXEPEN      0x04      
		#define    TXSTL       0x40      
		#define    RXSTL       0x80      
	#define    RXCNT       0xE6
	#define    RXCON       0xE4
		#define    RXFFRC      0x10      // RX FIFO Read Complete
		#define    RXCLR       0x80	 // Receive FIFO Clear
	#define    RXDAT       0xE3
	#define    RXSTAT      0xE2
		#define    RXSOVW      0x08
		#define    EDOVW       0x10
		#define    STOVW       0x20
		#define    RXSETUP     0x40
		#define    RXSEQ       0x80
        #define    TXCNT       0xF6
        #define    TXCON       0xF4
                #define    TXFFRC      0x10      // TX FIFO Read Complete
		#define    TXCLR       0x80	 // Transmit FIFO Clear	
	#define    TXDAT       0xF3
	#define    TXSTAT      0xF2
		#define    TXSOVW      0x08
		#define    TXSEQ       0x80
	#define    PFTH        0xCF
	#define    PFTL        0xCE
	#define    SFMCTL       0xCD              //
                #define    SFINX0        0x01
                #define    INX1        0x02
                #define    INX2        0x04
                #define    INX3        0x08
                #define    ASOF_G0     0x10      //
                #define    ASOF_G1     0x20      // 
                #define    DECEN       0x40
                #define    INCEN       0x80
        #define    MCKCTL      0xCC
	        #define    GCKD0       0x01
		#define    GCKD1       0x02
		#define    XI2GCK      0x04
		#define    FCKD        0x10
		#define    USBCKD      0x20
		#define    DPLLD       0x40
        #define    IOCTL       0xC2              //
                #define    MCKOE0      0x01
                #define    MCKOE1      0x02
                #define    MCKOE2      0x04
                #define    SIFOE0      0x08      // Real singal will be OUTPUT
                #define    SIFOE1      0x10      // Real singal will be OUTPUT
                #define    AIS1EN      0x20
                #define    DMI         0x40
                #define    DPI         0x80
        #define    PLLCON      0xC1              //
                #define    ENL         0x01
                #define    FSL0        0x02
                #define    FSL1        0x04
                #define    RTA         0x08
                #define    RTF         0x10
                #define    CFPL        0x20
                #define    PDSL        0x40
                #define    TESTL       0x80
*/                

#define    SETUPSTAGE          0xF0
#define    DATASTAGE           0x5A
#define    STATUSSTAGE         0xA5
#define    SETADDRESS          0x55


typedef struct
   { BYTE RWEN;                                  // Remote Wake Enable Flag
     BYTE EmuOk;                                 // EmuOk will set after "SET_CONFIGURATION"
     BYTE Stage;                                 // Index the next transaction are DATASTAGE or STATUSSTAGE
     BYTE RxTx[DFU_MAX];                         // For Rx/Tx FIFO
     BYTE *Buf;                                  // USB Tx Buffer Address , Maybe addressing to ROM address
     BYTE EpIndex;
     BYTE Unit;                                  // Transmit Unit size in byte
     WORD All;                                   // Transmit All size in byte
     BYTE Tmp;					 // Store some data for Next transaction( SET_ADDRESS/SET_CONFIGURATION/..)
     union DWTYPE DWLen;                         // 
     BYTE Out_AltSet;                            // For Set Interface ( Speaker )
     BYTE In_AltSet;                             // For Set Interface ( MIC/LINE_IN )
   } EP0INFO;                                    // Only for End Point 0
   


#define    GET_REQUEST         0x80

//-----Standard Request Code-----//
#define    GET_STATUS          0	 
#define    CLEAR_FRATURE       1
#define    SET_FEATURE         3
#define	   SET_ADDRESS         5
#define    GET_DESCRIPTOR      6
#define    SET_DESCRIPTOR      7
#define    GET_CONFIGURATION   8
#define    SET_CONFIGURATION   9
#define    GET_INTERFACE       10
#define    SET_INTERFACE       11
#define    SYNCH_FRAME         12

// HID Request Codes
#define    GET_REPORT          0x01
#define    GET_IDLE            0x02
#define    GET_PROTOCOL        0x03
#define    SET_REPORT          0x09
#define    SET_IDLE            0x0A
#define    SET_PROTOCOL        0x0B


#define    STANDARD_REQUEST    0x00
#define    CLASS_REQUEST       0x20
#define    VENDOR_REQUEST      0x40

//-----Request Type in Standard Request Code-----//
#define    DEVICEREQUEST        0x00
#define    INTERFACEREQUEST     0x01
#define    ENDPOINTREQUEST      0x02

//-----Feature Selectors in Standard Request Code-----//
#define    DEVICE_REMOTE_WAKEUP 0x01
#define    ENDPOINT_HALT        0x00

//-----Descriptor Type in Standard Request Code-----//
#define    DEVICEDESCRIPTOR        0x01
#define    CONFIGURATIONDESCRIPTOR 0x02
#define    STRINGDESCRIPTOR        0x03
#define    INTERFACEDESCRIPTOR     0x04
#define    ENDPOINTDESCRIPTOR      0x05
#define    HIDDESCRIPTOR           0x21
#define    HIDREPORT               0x22  


#define    REST_DEVICE         0x8F

//-----USB-Speaker Request Code-----//
#define    USBSPKSTAGE         0x0F


#define    GET_SPK_CUR         0x81
#define    GET_SPK_MIN         0x82
#define    GET_SPK_MAX         0x83
#define    GET_SPK_RES         0x84

#define    SET_SPK_CUR         0x01
#define    SET_SPK_VOL         0x21
#define    SET_FEQ_CTL         0x22


#define    PLL_LOCK_USB        0x30              // PLL Lock USB SOF
#define    PLL_LOCK_LCO        0x00              // PLL Lock LOCAL